/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeEditor
extends ControlEditor {
    Tree tree;
    TreeItem item;
    int column = 0;
    ControlListener columnListener;
    TreeListener treeListener;
    Runnable timer;
    static final int TIMEOUT = 1500;

    public TreeEditor(Tree tree) {
        super(tree);
        this.tree = tree;
        this.columnListener = new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                TreeEditor.this.layout();
            }

            public void controlResized(ControlEvent controlEvent) {
                TreeEditor.this.layout();
            }
        };
        this.timer = new Runnable(){

            public void run() {
                TreeEditor.this.layout();
            }
        };
        this.treeListener = new TreeListener(){
            final Runnable runnable = new Runnable(){

                public void run() {
                    if (TreeEditor.this.editor == null || TreeEditor.this.editor.isDisposed()) {
                        return;
                    }
                    if (TreeEditor.this.tree.isDisposed()) {
                        return;
                    }
                    TreeEditor.this.layout();
                    TreeEditor.this.editor.setVisible(true);
                }
            };

            public void treeCollapsed(TreeEvent treeEvent) {
                if (TreeEditor.this.editor == null || TreeEditor.this.editor.isDisposed()) {
                    return;
                }
                TreeEditor.this.editor.setVisible(false);
                treeEvent.display.asyncExec(this.runnable);
            }

            public void treeExpanded(TreeEvent treeEvent) {
                if (TreeEditor.this.editor == null || TreeEditor.this.editor.isDisposed()) {
                    return;
                }
                TreeEditor.this.editor.setVisible(false);
                treeEvent.display.asyncExec(this.runnable);
            }
        };
        tree.addTreeListener(this.treeListener);
        this.grabVertical = true;
    }

    Rectangle computeBounds() {
        if (this.item == null || this.column == -1 || this.item.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.item.getBounds(this.column);
        Rectangle rectangle2 = this.item.getImageBounds(this.column);
        rectangle.x = rectangle2.x + rectangle2.width;
        rectangle.width -= rectangle2.width;
        Rectangle rectangle3 = this.tree.getClientArea();
        if (rectangle.x < rectangle3.x + rectangle3.width && rectangle.x + rectangle.width > rectangle3.x + rectangle3.width) {
            rectangle.width = rectangle3.x + rectangle3.width - rectangle.x;
        }
        Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            if (this.tree.getColumnCount() == 0) {
                rectangle.width = rectangle3.x + rectangle3.width - rectangle.x;
            }
            rectangle4.width = Math.max(rectangle.width, this.minimumWidth);
        }
        if (this.grabVertical) {
            rectangle4.height = Math.max(rectangle.height, this.minimumHeight);
        }
        if (this.horizontalAlignment == 131072) {
            rectangle4.x += rectangle.width - rectangle4.width;
        } else if (this.horizontalAlignment != 16384) {
            rectangle4.x += (rectangle.width - rectangle4.width) / 2;
        }
        rectangle4.x = Math.max(rectangle.x, rectangle4.x);
        if (this.verticalAlignment == 1024) {
            rectangle4.y += rectangle.height - rectangle4.height;
        } else if (this.verticalAlignment != 128) {
            rectangle4.y += (rectangle.height - rectangle4.height) / 2;
        }
        return rectangle4;
    }

    public void dispose() {
        if (this.tree != null && !this.tree.isDisposed()) {
            if (this.column > -1 && this.column < this.tree.getColumnCount()) {
                TreeColumn treeColumn = this.tree.getColumn(this.column);
                treeColumn.removeControlListener(this.columnListener);
            }
            if (this.treeListener != null) {
                this.tree.removeTreeListener(this.treeListener);
            }
        }
        this.columnListener = null;
        this.treeListener = null;
        this.tree = null;
        this.item = null;
        this.column = 0;
        this.timer = null;
        super.dispose();
    }

    public int getColumn() {
        return this.column;
    }

    public TreeItem getItem() {
        return this.item;
    }

    void resize() {
        this.layout();
        if (this.tree != null) {
            Display display = this.tree.getDisplay();
            display.timerExec(-1, this.timer);
            display.timerExec(1500, this.timer);
        }
    }

    public void setColumn(int n) {
        TreeColumn treeColumn;
        int n2 = this.tree.getColumnCount();
        if (n2 == 0) {
            this.column = n == 0 ? 0 : -1;
            this.resize();
            return;
        }
        if (this.column > -1 && this.column < n2) {
            treeColumn = this.tree.getColumn(this.column);
            treeColumn.removeControlListener(this.columnListener);
            this.column = -1;
        }
        if (n < 0 || n >= this.tree.getColumnCount()) {
            return;
        }
        this.column = n;
        treeColumn = this.tree.getColumn(this.column);
        treeColumn.addControlListener(this.columnListener);
        this.resize();
    }

    public void setItem(TreeItem treeItem) {
        this.item = treeItem;
        this.resize();
    }

    public void setEditor(Control control, TreeItem treeItem, int n) {
        this.setItem(treeItem);
        this.setColumn(n);
        this.setEditor(control);
    }

    public void setEditor(Control control) {
        super.setEditor(control);
        this.resize();
    }

    public void setEditor(Control control, TreeItem treeItem) {
        this.setItem(treeItem);
        this.setEditor(control);
    }

    public void layout() {
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        if (this.item == null || this.item.isDisposed()) {
            return;
        }
        int n = this.tree.getColumnCount();
        if (n == 0 && this.column != 0) {
            return;
        }
        if (n > 0 && (this.column < 0 || this.column >= n)) {
            return;
        }
        super.layout();
    }
}

